<?php

/**
 * روش نصب:
 * 1- ویرایش توکن و شناسه ادمین
 * 2- ران کردن تمامی سورس و فایل های مورد نیاز در هاست/سرور
 * 3- باز کردن لینک این فایل در مرورگر
 * 
 * پایان :)
 * پ.ن: به ستوبهوک نیازی ندارید
 */

// Mmb: https://jahanbots

include "Mmb.php";

$mmb = new Mmb("2800232005:AABhirA0nl9p4M682Z0IG9Y_p7oi14-JWw1"); // توکن
$admin = 370924007; // شناسه ادمین

$db = new MmbJson("data");

if($upd = $mmb->getUpd()){
    if($msg = $upd->msg){

        // عدم پاسخ در چت هایی غیر شخصی
        if($msg->chat->type != Chat::TYPE_PRIVATE){
            exit;
        }

        $fromID = $msg->from->id;
        $text = $msg->text;

        $isAdmin = $fromID == $admin;

        // گرفتن اطلاعات کاربر از دیتابیس
        $user = $db->select("users", $fromID);
        if(!$user){
            $user = [
                'ban' => false
            ];
            $db->insert("users", $fromID, $user);
        }

        // بررسی بن بودن کاربر
        if($user['ban']){
            exit;
        }

        // شروع ربات
        if($msg->started){
            if($isAdmin){
                $msg->replyText("ادمین گرامی، خوش آمدید!\nپیام های کاربران برای شما ارسال می شود و شما با ریپلای کردن به آنها پاسخ می دهید!\n\n\nدستورات:\nریپلای + بن = بن کردن کاربر مقابل\nریپلای + حذف بن = حذف بن کاربر\nریپلای = ارسال پیام به کاربر", [
                    'key' => [
                        [['text' => "آمار"]]
                    ]
                ]);
            }
            else{
                $msg->replyText("به ربات پشتیبانی خوش آمدید!\n\nپیام خود را جهت ارسال به ادمین، ارسال کنید", [
                    'key' => Keys::removeKey()
                ]);
            }
        }

        // بررسی ریپلای کردن ادمین
        elseif($isAdmin && $msg->reply && ($dt = $db->select("msgs", $msg->reply->id))){
            $to = $dt['chat'];
            $mid = $dt['msg'];

            // دستور بن
            if($text == "بن"){
                $db->update("users", $to, [
                    'ban' => true
                ]);
                $msg->replyText("بن شد!");
            }

            // دستور حذف بن
            elseif($text == "حذف بن"){
                $db->update("users", $to, [
                    'ban' => false
                ]);
                $msg->replyText("کاربر از حالت بن خارج شد");
            }

            // پاسخ به کاربر
            else{
                try{
                    // در صورت متن بودن
                    if($msg->type == Msg::TYPE_TEXT){
                        $mmb->sendMsg([
                            'chat' => $to,
                            'reply' => $mid,
                            'text' => $text
                        ]);
                    }
                    // در صورت رسانه بودن
                    elseif($msg->media){
                        $mmb->send($msg->type, [
                            'chat' => $to,
                            'reply' => $mid,
                            'text' => $text,
                            'val' => $msg->media_id
                        ]);
                    }
                    else{
                        $msg->replyText("از این پیام پشتیبانی نمی شود!");
                        return;
                    }
                    $msg->replyText("پیام با موفقیت ارسال شد");
                }
                // در صورت بروز خطا
                catch(Exception$e){
                    $msg->replyText("پیام ارسال نشد!");
                }
            }

        }

        // ارسال پیام به ادمین
        elseif(!$isAdmin){
            try{
                $msg2 = $msg->forwardTo($admin);
                $db->insert("msgs", $msg2->id, [
                    'chat' => $fromID,
                    'msg' => $msg->id
                ]);
                $msg->replyText("پیام شما ارسال شد");
            }
            catch(Exception$e){
                $msg->replyText("پیام ارسال نشد");
            }
        }

        // آمار
        elseif($isAdmin && $text == "آمار"){
            $msg->replyText("تعداد کاربران: " . $db->number("users"));
        }

    }
}

// Mmb: https://jahanbots
